@ECHO OFF
SETLOCAL

REM ╔════════════════════════════════════════════════════════════════════════╗
REM ║ This script will dynamically create the external.xml file              ║
REM ║                                                                        ║
REM ║ How to use:                                                            ║
REM ║ 1. Create a folder named "ext"                                         ║
REM ║ 2. Move all enemy flash files into that folder but not the game itself ║
REM ║ 3. Run this file                                                       ║
REM ║ 4. Launch the game                                                     ║
REM ║ 5. Run this file again each time the "ext" folder contents change      ║
REM ╠════════════════════════════════════════════════════════════════════════╣
REM ║ Feel free to edit the parameters below. Make sure to read the comments ║
REM ╚════════════════════════════════════════════════════════════════════════╝

REM Name of the folder. "ext" by default but if you hate it you can change it.
SET FOLDER=ext

REM Name of the xml file. As of now, this is always "external.xml" and should not be changed.
SET XML=external.xml

REM Name of each entry in the file.
REM panftr: enemy
REM others: entry
SET NODE=enemy

REM ███████████████████████████████████████████████████████████████████████████
REM ███ CAUTION! No changes needed below. Only edit if you know what you do ███
REM ███████████████████████████████████████████████████████████████████████████

REM Apply defaults to empty settings
IF "%FOLDER%"=="" SET FOLDER=ext
IF "%XML%"=="" SET XML=external.xml
IF "%NODE%"=="" SET NODE=entry

REM Set the working directory to where this script is
PUSHD "%~dp0"

REM Check if the folder exists, if not, abort and tell the user
IF NOT EXIST "%FOLDER%" GOTO NODIR

REM If we can't find any SWF files, abort and tell the user
IF NOT EXIST "%FOLDER%\*.swf" GOTO NOFILES

REM Remove attributes from the xml file so we can overwrite it
IF EXIST "%XML%" ATTRIB -A -H -R -S "%XML%"

SET GAMECOUNT=0

REM The symbols ">" and "<" have special meaning in your console. They redirect output.
REM The symbol "^" tells the console to take the next symbol "as is" instead of interpreting it.
REM This allows us to write XML code.

REM Write: <xml>
ECHO ^<xml^>>"%XML%"
REM Write: <!--
ECHO ^<!-->>"%XML%"
REM Write XML comment text
ECHO Created by %~nx0 on %DATE% %TIME%>>"%XML%"
ECHO.>>"%XML%"
ECHO DO NOT EDIT MANUALLY!>>"%XML%"
ECHO All changes in this file will be overwritten if %~nx0 is run again>>"%XML%"
REM Write: -->
ECHO --^>>>"%XML%"

REM Write an empty line
ECHO.>>"%XML%"

REM Searches for all swf files in your enemy folder and does the commands between the parenthesis for each one of them
FOR %%I IN ("%FOLDER%\*.swf") DO (
SET /A GAMECOUNT=GAMECOUNT+1
REM Write: <entry path="file_goes_here" />
ECHO ^<%NODE% path="%FOLDER%/%%~nxI" /^>>>"%XML%"
)

REM Write: </xml>
ECHO ^</xml^>>>"%XML%"

REM Write statistics
ECHO %XML% created.
ECHO Enemy count: %GAMECOUNT%
PAUSE
REM Jump to the end marker
GOTO END


:NODIR
REM Enemy file directory not found
ECHO Error: Directory not found
ECHO ==========================
ECHO %CD%\%FOLDER%
ECHO Edit this script and change the "FOLDER" setting.
ECHO Alternatively, create the directory and put the enemy files inside of it.
ECHO.
ECHO Press any key to exit this script
REM >NUL makes the pause command silent.
PAUSE>NUL
GOTO END

:NOFILES
REM We did not find any SWF files
ECHO Error: No enemy files found
ECHO ===========================
ECHO Could not find any enemy files inside the directory "%FOLDER%".
ECHO Create the directory if it does not exists and move the enemy files into it.
ECHO After you are done, run this file again to create the XML.
ECHO.
ECHO DO NOT move the main game file itself into that directory.
ECHO.
ECHO Press any key to exit this script
REM >NUL makes the pause command silent.
PAUSE>NUL
REM Jump to the end marker.
REM Technically not needed if it's the next marker in the file, but it's cleaner to do this
GOTO END

:END
REM We're done. Undo the PUSHD from the start and clear the variables
POPD
ENDLOCAL